# Databricks notebook source

# Import the configuration
from config.main import config

# Use configuration from config module
catalog_name = config.get_catalog_name()
schema_name = config.get_schema_name()
team_name = config.get_team_name()
volume_name = "usd_nok_exchange_rate"
src_schema_name = f"{schema_name}_raw"
src_volume_name = "usd_nok_exchange_rate"
developer_team = f"{team_name}_developers"
owners_team = f"{team_name}_owners"

input_path = f"/Volumes/{catalog_name}/{src_schema_name}/{src_volume_name}/"

# COMMAND ----------

dst_schema_name = schema_name
dst_table_name = "usd_nok_exchange_rate_parsed"
volume_name = "checkpoint"
checkpoint_location = (
    f"/Volumes/{catalog_name}/{dst_schema_name}/{volume_name}/_checkpoints"
)

schema_location = f"/Volumes/{catalog_name}/{dst_schema_name}/{volume_name}/schema"
